/*
 * Decompiled with CFR 0.152.
 */
package fonnymunkey.simplehats.compat;

import fonnymunkey.simplehats.common.init.ModRegistry;
import fonnymunkey.simplehats.common.item.HatItem;
import fonnymunkey.simplehats.common.item.HatItemDyeable;
import fonnymunkey.simplehats.util.HatEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.PartialNBTIngredient;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("simplehats", "jei_compat");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        List<CraftingRecipe> list = JEIPlugin.createHatScrapRecipe();
        list.addAll(JEIPlugin.createHatVariantRecipe());
        list.addAll(JEIPlugin.createHatDyeRecipe());
        if (!list.isEmpty()) {
            registration.addRecipes(RecipeTypes.CRAFTING, list);
        }
    }

    private static List<CraftingRecipe> createHatScrapRecipe() {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        ArrayList<Ingredient> easterList = new ArrayList<Ingredient>();
        ArrayList summerList = new ArrayList();
        ArrayList halloweenList = new ArrayList();
        ArrayList festiveList = new ArrayList();
        ArrayList commonList = new ArrayList();
        ArrayList uncommonList = new ArrayList();
        ArrayList rareList = new ArrayList();
        for (HatItem hat : ModRegistry.hatList) {
            (switch (hat.getHatEntry().getHatSeason()) {
                default -> throw new IncompatibleClassChangeError();
                case HatEntry.HatSeason.EASTER -> easterList;
                case HatEntry.HatSeason.SUMMER -> summerList;
                case HatEntry.HatSeason.HALLOWEEN -> halloweenList;
                case HatEntry.HatSeason.FESTIVE -> festiveList;
                case HatEntry.HatSeason.NONE -> {
                    switch (hat.getHatEntry().getHatRarity()) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case COMMON: {
                            yield commonList;
                        }
                        case UNCOMMON: {
                            yield uncommonList;
                        }
                        case RARE: 
                        case EPIC: 
                    }
                    yield rareList;
                }
            }).add(Ingredient.m_43929_((ItemLike[])new ItemLike[]{hat}));
        }
        Map map = Map.of((Item)ModRegistry.HATSCRAPS_EASTER.get(), easterList, (Item)ModRegistry.HATSCRAPS_SUMMER.get(), summerList, (Item)ModRegistry.HATSCRAPS_HALLOWEEN.get(), halloweenList, (Item)ModRegistry.HATSCRAPS_FESTIVE.get(), festiveList, (Item)ModRegistry.HATSCRAPS_COMMON.get(), commonList, (Item)ModRegistry.HATSCRAPS_UNCOMMON.get(), uncommonList, (Item)ModRegistry.HATSCRAPS_RARE.get(), rareList);
        for (Map.Entry entry : map.entrySet()) {
            if (((List)entry.getValue()).isEmpty()) continue;
            ResourceLocation location = new ResourceLocation("simplehats", entry.getKey().getRegistryName().m_135815_() + "_scrapping");
            recipes.add((CraftingRecipe)new ShapelessRecipe(location, RecipeTypes.CRAFTING.getUid().m_135815_(), new ItemStack((ItemLike)entry.getKey()), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42574_}), CompoundIngredient.of((Ingredient[])((List)entry.getValue()).toArray(new Ingredient[0]))})));
        }
        return recipes;
    }

    private static List<CraftingRecipe> createHatVariantRecipe() {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        for (HatItem hat : ModRegistry.hatList) {
            if (hat.getHatEntry().getHatVariantRange() <= 0) continue;
            for (int i = 0; i <= hat.getHatEntry().getHatVariantRange(); ++i) {
                CompoundTag tag = new CompoundTag();
                tag.m_128405_("CustomModelData", i);
                NonNullList input = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{PartialNBTIngredient.of((ItemLike)hat, (CompoundTag)tag)});
                CompoundTag tag1 = new CompoundTag();
                tag1.m_128405_("CustomModelData", (i + 1) % (hat.getHatEntry().getHatVariantRange() + 1));
                ItemStack stack1 = new ItemStack((ItemLike)hat);
                stack1.m_41751_(tag1);
                ItemStack output = stack1;
                ResourceLocation location = new ResourceLocation("simplehats", "hatvariant_" + hat.getRegistryName().m_135815_() + "_" + i);
                recipes.add((CraftingRecipe)new ShapelessRecipe(location, RecipeTypes.CRAFTING.getUid().m_135815_(), output, input));
            }
        }
        return recipes;
    }

    private static List<CraftingRecipe> createHatDyeRecipe() {
        ArrayList<CraftingRecipe> recipes = new ArrayList<CraftingRecipe>();
        for (HatItem hat : ModRegistry.hatList) {
            if (!(hat instanceof HatItemDyeable)) continue;
            HatItemDyeable hatDyeable = (HatItemDyeable)hat;
            ResourceLocation location = new ResourceLocation("simplehats", "hatdyeing_" + hat.getRegistryName().m_135815_());
            recipes.add((CraftingRecipe)new ShapelessRecipe(location, RecipeTypes.CRAFTING.getUid().m_135815_(), new ItemStack((ItemLike)hat), NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{Ingredient.m_204132_((TagKey)Tags.Items.DYES), Ingredient.m_43929_((ItemLike[])new ItemLike[]{hat})})));
        }
        return recipes;
    }
}

